<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\Question */

$this->title = 'Изменить вопрос';
$this->params['breadcrumbs'][] = ['label' => 'Опросы', 'url' => ['/survey/index']];
$this->params['breadcrumbs'][] = ['label' => $model->survey->title, 'url' => ['/survey/view', 'id' => $model->survey_id]];
$this->params['breadcrumbs'][] = ['label' => 'Вопросы', 'url' => ['index', 'survey_id' => $model->survey_id]];
$this->params['breadcrumbs'][] = 'Изменить';
?>
<div class="question-update">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'form-label'],
            'inputOptions' => ['class' => 'form-control'],
            'errorOptions' => ['class' => 'invalid-feedback'],
        ],
    ]); ?>

    <?= $form->field($model, 'question_text')->textarea(['rows' => 3]) ?>

    <?= $form->field($model, 'type')->dropDownList([
        app\models\Question::TYPE_TEXT => 'Текстовый ответ',
        app\models\Question::TYPE_SCALE => 'Оценка по шкале (1-5)',
        app\models\Question::TYPE_SINGLE_CHOICE => 'Выбор одного варианта',
    ]) ?>

    <?= $form->field($model, 'order')->input('number', ['min' => 1]) ?>

    <div class="form-group mt-3">
        <?= Html::submitButton('Сохранить', ['class' => 'btn btn-success']) ?>
        <?= Html::a('Отмена', ['index', 'survey_id' => $model->survey_id], ['class' => 'btn btn-secondary']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>