<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ListView;
use yii\data\ActiveDataProvider;

/* @var $this yii\web\View */
/* @var $survey app\models\Survey */
/* @var $questions app\models\Question[] */

$this->title = 'Вопросы опроса: ' . $survey->title;
$this->params['breadcrumbs'][] = ['label' => 'Опросы', 'url' => ['/survey/index']];
$this->params['breadcrumbs'][] = ['label' => $survey->title, 'url' => ['/survey/view', 'id' => $survey->id]];
$this->params['breadcrumbs'][] = 'Вопросы';
?>
<div class="question-index">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1><?= Html::encode($this->title) ?></h1>
        <div>
            <?= Html::a('Назад к опросу', ['/survey/view', 'id' => $survey->id], ['class' => 'btn btn-secondary']) ?>
            <?= Html::a('Добавить вопрос', ['create', 'survey_id' => $survey->id], ['class' => 'btn btn-success']) ?>
        </div>
    </div>

    <?php if (empty($questions)): ?>
        <div class="alert alert-info">
            В этом опросе пока нет вопросов. Добавьте первый вопрос!
        </div>
    <?php else: ?>
        <div class="list-group">
            <?php foreach ($questions as $index => $question): ?>
                <div class="list-group-item">
                    <div class="d-flex w-100 justify-content-between align-items-start">
                        <div class="me-3">
                            <h5 class="mb-1">
                                <?= ($index + 1) ?>. <?= Html::encode($question->question_text) ?>
                            </h5>
                            <p class="mb-1">
                                <span class="badge bg-info"><?= $question->getTypeName() ?></span>
                                <small class="text-muted">Порядок: <?= $question->order ?></small>
                            </p>
                        </div>
                        <div class="btn-group btn-group-sm">
                            <?php if ($index > 0): ?>
                                <?= Html::a('↑', ['move-up', 'id' => $question->id], [
                                    'class' => 'btn btn-outline-secondary',
                                    'title' => 'Поднять выше'
                                ]) ?>
                            <?php endif; ?>
                            
                            <?php if ($index < count($questions) - 1): ?>
                                <?= Html::a('↓', ['move-down', 'id' => $question->id], [
                                    'class' => 'btn btn-outline-secondary',
                                    'title' => 'Опустить ниже'
                                ]) ?>
                            <?php endif; ?>
                            
                            <?= Html::a('Изменить', ['update', 'id' => $question->id], [
                                'class' => 'btn btn-outline-primary'
                            ]) ?>
                            
                            <?= Html::a('Удалить', ['delete', 'id' => $question->id], [
                                'class' => 'btn btn-outline-danger',
                                'data' => [
                                    'confirm' => 'Вы уверены, что хотите удалить этот вопрос?',
                                    'method' => 'post',
                                ],
                            ]) ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="mt-4">
            <p class="text-muted">
                <small>Всего вопросов: <?= count($questions) ?></small>
            </p>
        </div>
    <?php endif; ?>
</div>