<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%answer}}`.
 */
class m251214_103921_create_answer_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%answer}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'question_id' => $this->integer()->notNull(),
            'answer_value' => $this->text()->notNull(),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

         $this->addForeignKey(
            'fk-answer-user_id',
            '{{%answer}}',        
            'user_id',        
            '{{%user}}',         
            'id',                  
            'CASCADE',             
            'CASCADE'              
        );

         $this->addForeignKey(
            'fk-answer-question_id',
            '{{%answer}}',   
            'question_id',        
            '{{%question}}',      
            'id',                 
            'CASCADE',             
            'CASCADE'              
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%answer}}');
    }
}
